<?php
include dirname(__FILE__).'/admin/config.php';

$page_title = "Add a Website to the $site_name";
$meta = "Listing site at $site_name, Add a Website to the $site_name";

if(isset($_POST['ajax_category_id']) && $_POST['ajax_category_id'] != "")
{
	$categories = ORM::for_table('Categories')->where_equal("link_to_category",$_POST['ajax_category_id'])->find_many();
	if(count($categories) > 0 )
	{
		echo '<select class="form-control cat" name="categoryID[]">
				<option value="">--Select--</option>
				';
		foreach($categories as $category)
		{
			echo '<option value="'.$category->ID.'">'.$category->CategoryName.'</option>';
		}
		echo '</select>';
	}
	else
	{
		echo '<select class="form-control cat" name="categoryID[]">
				<option value="">--Select--</option>
				';
		echo '</select>';
	}
	exit();
}

include dirname(__FILE__).'/header.php';

if(isset($_SESSION['user_id']) && $_SESSION['user_id'] != "")
{
}
else
{
	header('location:'.$base_url.'pages/login');
}
?>
    <div class="container"><div class="content">
	<?php

	// We check if the form has been submitted
	if( isset($_POST['confirmation']) && $_POST['confirmation']=='true' ) {
		//print_r($_POST);
		$validate = true;
		$messages = array();
		
		if ( !isset($_POST['name']) OR empty($_POST['name']) ){
			$messages['name'] = 'Website Name cannot be empty.';
		} else if ( strlen($_POST['name'])>55 ){
			$messages['name'] = 'Website Name is too long. Maximum is 55 characters please.';
		}
		
		if ( !isset($_POST['url']) OR empty($_POST['url']) ){
			$messages['url'] = 'Website URL cannot be empty.';
		}
		
		if ( !isset($_POST['description']) OR empty($_POST['description']) ){
			$messages['description'] = 'Description cannot be empty.';
		} else if ( strlen($_POST['description'])>255 ){
			$messages['description'] = 'Description is too long. Maximum is 255 characters please.';
		}
		
		if ( !isset($_POST['email']) OR empty($_POST['email']) ){
			$messages['email'] = 'Email cannot be empty.';
		} else {
			$regex = '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/';
			if ( !preg_match($regex, $_POST['email']) ) {
				$messages['email'] = $_POST['email'] . " is an invalid email. Please try again.";
			}
		}
		
		if ( count($messages) > 0 ){
			display_form($_POST, $messages);
		} else {
			$_POST['categoryID'] = array_diff($_POST['categoryID'],array(""));
			
			$cat = implode(",",$_POST['categoryID']);
			$category = ",".$cat.",";
			
			// We get the future ID of the Website
			$max_id = ORM::for_table($table_name)->select_expr('MAX(id)', 'id')->find_one();
			$id = intval($max_id['id']) + 1;
			$hash_key = sha1(md5($id.$site_name));
			
			// We send an email to the webmaster
			if($mail) {
				$subject = 'Your website subscription - Top site';
				$message = "Hi,
You recieve this message after the subscription of your website(".$_POST['url'].") on our top site.
An Admin will check it soon and decide to accept it or not.
You can start earning votes by sharing the following link on your website:

<a href=\"" . $base_url . "in/".$hash_key."\">Vote for this Website</a>

Thank you";
				
				$to = $_POST['email'];
				$headers = "From: \"Top site\" <".$mail_webmaster.">\n";
				$headers .= "cc: ".$mail_webmaster."\n";
				$headers .= "Content-Type: text/plain; charset=\"utf-8\"";
				mail($to, $subject, $message, $headers);
			}
			/*foreach($_POST['categoryID'] as $post)
			{
				if($post != "")
				{
					$category = $post;
				}
			}*/
			// We protect the variables and we limit the number of letters of some fields
		
			$query = ORM::get_db()->prepare("INSERT INTO `$table_name` (id, name, url, description, banner, email,add_date, votes, status,categoryID,user_id,hash_key) values (:id, :name, :url, :description, :banner, :email,:add_date, 0, 'no','".$category."','".$_SESSION['user_id']."','".$hash_key."')");
			$query->bindParam(':id', $id, PDO::PARAM_INT);
			$query->bindParam(':name', $_POST['name'], PDO::PARAM_STR, 55);
			$query->bindParam(':url', $_POST['url'], PDO::PARAM_STR);
			$query->bindParam(':description', $_POST['description'], PDO::PARAM_STR, 255);
			$query->bindParam(':banner', $_POST['banner'], PDO::PARAM_STR);
			$query->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
			$query->bindParam(':add_date', date("Y-m-d"), PDO::PARAM_STR);
		//print_r($query);//die();
			// On ajoute le site a la bdd
			if( $query->execute() ) {
				$_SESSION['data'] = '<strong>Your website has successfully been submited, an admin will check it soon.</strong><br />
You can start earning votes:<br />
<input type="text" value="' . htmlentities('<a href="' . $base_url . 'in/' . $hash_key . '">Vote for this Website</a>').'" size="50" onclick="this.select();" />';
			} else {
				$_SESSION['msg'] = '<strong>An error occurred while submitting the website.</strong>';
			}
			header("location:".$base_url."/pages/new");
			exit;
		}
	}
	else if(isset($_SESSION['data']) && $_SESSION['data'] != "")
	{
		echo $_SESSION['data'];
		unset($_SESSION['data']);
	} 
	else {
		display_form();
	}

function display_form($data = array(), $errors=array()){
	global $display_form;
	if ( isset($display_form) ) return;
	$display_form = true;
	
	//We display the form
	?>
	<?php if (count($errors)): ?>
	<div class="alert alert-danger" role="alert">
		<ol class="text-left" style="margin: 0;">
		<?php foreach ($errors as $n => $m): ?>
			<li><?php echo $m; ?></li>
		<?php endforeach; ?>
		</ol>
	</div>
	<?php else: ?>
	<p class="lead">To add your website to this top site, you have to fill the following form:</p>
	<?php endif; ?>
	
	<script>
		$(function(){
			
			$(".cat").change(function(){
				var cur_drp = $(this).attr('id');
				var next_drp = $(this).attr('next_id');
				
				var cat_id = $(this).val();
				
				if(next_drp == "category3")
				{
					
				}
				else
				{
					$("#drp"+next_drp).hide();
					$("#"+next_drp).html('<select class="form-control cat" name="categoryID[]">' +
										'<option value="">--Select--</option></select>');
					$("#drpcategory2").hide();
					$("#category2").html('<select class="form-control cat" name="categoryID[]">' +
										'<option value="">--Select--</option></select>');
				}
				
				if(cat_id != "")
				{
					$.ajax({
						url:"<?php echo $base_url?>pages/new",
						data:{ajax_category_id:cat_id},
						type:"POST",
						success:function(result){
							//alert(result);
							if(result == "")
							{
								$("#drp"+next_drp).hide();
								$("#"+next_drp).html('<select class="form-control cat" name="categoryID[]" id="category1" next_id = "category2">' +
													'<option value="">--Select--</option></select>');
								$("#drpcategory2").hide();
								$("#category2").html('<select class="form-control cat" name="categoryID[]" id="category2" next_id = "category3">' +
													'<option value="">--Select--</option></select>');
							}
							else
							{
								$("#drp" + next_drp).show();
								$("#"+next_drp).html(result);
							}
						}
					});
				}
			});
		});
	</script>
	
	<form action="" method="post" class="form-horizontal" accept-charset="utf-9">
	<div class="form-group">
			<label class="control-label col-md-3" for="categoryID">Category</label>
			<div class="controls col-md-9 col-xs-12" id="drpcat">
				<select class="form-control cat" name="categoryID[]" id="category" next_id = 'category1'>
					<option value="">--Select--</option>
                <?php 
                $categories = ORM::for_table('Categories')->where_equal("link_to_category","0")->find_many();
foreach($categories as $category) {
    ?>
                <option value="<?php echo $category->ID; ?>"><?php echo $category->CategoryName; ?></option>
                 <?php } ?>
                </select>
			</div>
		</div>
		<div class="form-group" id="drpcategory1" style="display:none">
			<div class="controls col-md-offset-3 col-md-9 col-xs-12">
				<select class="form-control cat" name="categoryID[]" id="category1" next_id = 'category2'>
					<option value="">--Select--</option>
				</select>
			</div>
		</div>
		<div class="form-group" id="drpcategory2" style="display:none">
			<div class="controls col-md-offset-3 col-md-9 col-xs-12">
				<select class="form-control cat" name="categoryID[]" id="category2" next_id = 'category3'>
					<option value="">--Select--</option>
                </select>
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('name', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="name">Website Name</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="name" id="name" value="<?php echo isset($data['name']) ? $data['name'] : ''; ?>" maxlength="55" placeholder="Website Name" />
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('url', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="url">URL</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="url" id="url" value="<?php echo isset($data['url']) ? $data['url'] : ''; ?>" placeholder="Website URL"/>
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('description', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="description">Description</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="description" id="description" maxlength="255" value="<?php echo isset($data['description']) ? $data['description'] : ''; ?>" placeholder="Website Description" />
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('banner', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="banner">Banner</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="banner" id="banner" value="<?php echo isset($data['banner']) ? $data['banner'] : ''; ?>" placeholder="Banner image url" />
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('email', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="url">Email</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="email" id="email" value="<?php echo isset($data['email']) ? $data['email'] : ''; ?>" placeholder="Your email" />
			</div>
		</div>
		<div class="form-group">
			<div class="col-md-3"><input type="hidden" name="confirmation" value="true" /></div>
			<div class="controls col-md-9 col-xs-12">
				<input type="submit" value="Submit" class="btn btn-success btn-block" />
			</div>
		</div>
		
	</form>
	<?php
	if(isset($_SESSION['msg']) && $_SESSION['msg'] != "")
	{
		echo $_SESSION['msg'];
		unset($_SESSION['msg']);
	}
}
?>
    </div></div>
<?php
include dirname(__FILE__).'/footer.php';

?>


