<?php
include dirname(__FILE__).'/config.php';

$page_title = "Add a Website to the $site_name";

include dirname(__FILE__).'/admin_header.php';

if(isset($_SESSION['logged']) && $_SESSION['logged'] != "")
{
}
else
{
	header('location:login.php');
}

?>
    <div class="content">
	<?php
	
	// We check if the form has been submitted
	if( isset($_POST['confirmation']) && $_POST['confirmation']=='true' ) {
		
		$validate = true;
		$messages = array();
		
		if ( !isset($_POST['name']) OR empty($_POST['name']) ){
			$messages['name'] = 'Website Name cannot be empty.';
		} else if ( strlen($_POST['name'])>55 ){
			$messages['name'] = 'Website Name is too long. Maximum is 55 characters please.';
		}
		
		if ( !isset($_POST['url']) OR empty($_POST['url']) ){
			$messages['url'] = 'Website URL cannot be empty.';
		}
		
		if ( !isset($_POST['description']) OR empty($_POST['description']) ){
			$messages['description'] = 'Description cannot be empty.';
		} else if ( strlen($_POST['description'])>255 ){
			$messages['description'] = 'Description is too long. Maximum is 255 characters please.';
		}
		
		if ( !isset($_POST['email']) OR empty($_POST['email']) ){
			$messages['email'] = 'Email cannot be empty.';
		} else {
			$regex = '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/';
			if ( !preg_match($regex, $_POST['email']) ) {
				$messages['email'] = $_POST['email'] . " is an invalid email. Please try again.";
			}
		}
		
		if ( count($messages) > 0 ){
			display_form($_POST, $messages);
		} else {
		
			$_POST['categoryID'] = array_diff($_POST['categoryID'],array(""));
			
			$cat = implode(",",$_POST['categoryID']);
			
			$category = ",".$cat.",";
			
			// We protect the variables and we limit the number of letters of some fields
			//print_r($category);die();
			
			$query = ORM::get_db()->prepare("update `topsite` set name='".$_POST['name']."', url='".$_POST['url']."', description=\"".$_POST['description']."\", banner='".$_POST['banner']."', email='".$_POST['email']."', CategoryID='".$category."' where id=".$_POST['txtid']);
			// On ajoute le site a la bdd
			
			if( $query->execute() ) {
				echo '<strong>Your Link has successfully been Updated';
				
				if(isset($_GET['redirect_uri']) && $_GET['redirect_uri'] != "")
				{
					header("Location:/".$_GET['redirect_uri']);
				}
				else
				{
					header("Location:admin.php");
				}
			} else {
				echo '<strong>Your Link has Not Updated</strong>';
			}
		}
	} else {
		display_form();
	}

function display_form($data = array(), $errors=array()){
	global $display_form;
	if ( isset($display_form) ) return;
	$display_form = true;
	
	//We display the form
	?>
	<?php if (count($errors)): ?>
	<div class="alert alert-danger" role="alert">
		<ol class="text-left" style="margin: 0;">
		<?php foreach ($errors as $n => $m): ?>
			<li><?php echo $m; ?></li>
		<?php endforeach; ?>
		</ol>
	</div>
	<?php else: ?>
	<p class="lead">To add your website to this top site, you have to fill the following form:</p>
	<?php endif; 
	//$req2 = ORM::for_table('topsite')->raw_query('select * from topsite where id=$_GET["id"]');
        $site = ORM::for_table('topsite')->where('id', $_GET["id"])->find_one();
		
		$cat_arr = explode(",",$site->categoryID);
		$cat_arr = array_diff($cat_arr,array(""));
		
		$cat_arr = explode(",",implode(",",$cat_arr));
		//unset($cat_arr[count($cat_arr)-1]);
		//print_r($cat_arr);
		
	?>
	<script>
		$(function(){
			
			$(".cat").change(function(){
				var cur_drp = $(this).attr('id');
				var next_drp = $(this).attr('next_id');
				
				var cat_id = $(this).val();
				
				if(next_drp == "category3")
				{
					
				}
				else
				{
					$("#drp"+next_drp).hide();
					$("#"+next_drp).html('<select class="form-control cat" name="categoryID[]">' +
										'<option value="">--Select--</option></select>');
					$("#drpcategory2").hide();
					$("#category2").html('<select class="form-control cat" name="categoryID[]">' +
										'<option value="">--Select--</option></select>');
				}
				
				if(cat_id != "")
				{
					$.ajax({
						url:"new.php",
						data:{ajax_category_id:cat_id},
						type:"POST",
						success:function(result){
							if(result == "")
							{
								$("#drp"+next_drp).hide();
							}
							else
							{
								$("#drp" + next_drp).show();
								$("#"+next_drp).html(result);
							}
						}
					});
				}
			});
		});
		
	</script>
	
	<form action="" method="post" class="form-horizontal" accept-charset="utf-9">
    	<div class="form-group">
			<label class="control-label col-md-3" for="categoryID">Category</label>
			<div class="controls col-md-9 col-xs-12">
				<select class="form-control cat" name="categoryID[]" id="category" next_id = 'category1'>
					<option value="">--Select--</option>
                <?php 
                $categories = ORM::for_table('Categories')->where_equal("link_to_category","0")->find_many();
				foreach($categories as $category) 
				{
					if($category->ID == $cat_arr[0])
					{
					?>
						<option value="<?php echo $category->ID; ?>" selected=selected><?php echo $category->CategoryName; ?></option>
					<?php 
					}
					else
					{
					?>
						<option value="<?php echo $category->ID; ?>"><?php echo $category->CategoryName; ?></option>
					<?php
					}
				}
				?>
                </select>
			</div>
		</div>
		<div class="form-group" id="drpcategory1" <?php if(empty($cat_arr[1])) { echo 'style="display:none"'; } ?>>
			<div class="controls col-md-offset-3 col-md-9 col-xs-12">
				<select class="form-control cat" name="categoryID[]" id="category1" next_id = 'category2'>
					<option value="">--Select--</option>
					<?php 
					
				if(!empty($cat_arr[1]))
				{
					$sub_categories = ORM::for_table('Categories')->where_equal("link_to_category",$cat_arr[0])->find_many();
					foreach($sub_categories as $category) 
					{
						if($category->ID == $cat_arr[1])
						{
						?>
							<option value="<?php echo $category->ID; ?>" selected=selected><?php echo $category->CategoryName; ?></option>
						<?php 
						}
						else
						{
						?>
							<option value="<?php echo $category->ID; ?>"><?php echo $category->CategoryName; ?></option>
						<?php
						}
					}
				}
					?>
				</select>
			</div>
		</div>
		<div class="form-group" id="drpcategory2" <?php if(empty($cat_arr[2])){ echo 'style="display:none"'; } ?>>
			<div class="controls col-md-offset-3 col-md-9 col-xs-12">
				<select class="form-control cat" name="categoryID[]" id="category2" next_id = 'category3'>
					<option value="">--Select--</option>
					
					<?php

				if(!empty($cat_arr[2]))
				{					
					$sub_categories1 = ORM::for_table('Categories')->where_equal("link_to_category",$cat_arr[1])->find_many();
					foreach($sub_categories1 as $category) 
					{
						if($category->ID == $cat_arr[2])
						{
						?>
							<option value="<?php echo $category->ID; ?>" selected=selected><?php echo $category->CategoryName; ?></option>
						<?php 
						}
						else
						{
						?>
							<option value="<?php echo $category->ID; ?>"><?php echo $category->CategoryName; ?></option>
						<?php
						}
					}
				}
					?>
                </select>
			</div>
		</div>
		
		<div class="form-group<?php if(array_key_exists('name', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="name">Website Name</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="hidden" name="txtid" id="txtid" value="<?php if(isset($site->id)){echo $site->id;}?>"  />
				<input class="form-control" type="text" name="name" id="name" value="<?php if(isset($site->name)){echo $site->name;}?>" maxlength="55" placeholder="Website Name" />
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('url', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="url">URL</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="url" id="url" value="<?php if(isset($site->url)){echo $site->url;}?>" placeholder="Website URL"/>
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('description', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="description">Description</label>
			<div class="controls col-md-9 col-xs-12">
				<textarea class="form-control" type="text" name="description" maxlength="255" id="description" placeholder="Website Description"><?php if(isset($site->description)){echo $site->description;}?></textarea>
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('banner', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="banner">Banner</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="banner" id="banner" value="<?php if(isset($site->banner)){echo $site->banner;}?>" placeholder="Banner image url" />
			</div>
		</div>
		<div class="form-group<?php if(array_key_exists('email', $errors)) echo ' has-error'; ?>">
			<label class="control-label col-md-3" for="url">Email</label>
			<div class="controls col-md-9 col-xs-12">
				<input class="form-control" type="text" name="email" id="email" value="<?php if(isset($site->email)){echo $site->email;}?>" placeholder="Your email" />
			</div>
		</div>
		<div class="form-group">
			<div class="col-md-3"><input type="hidden" name="confirmation" value="true" /></div>
			<div class="controls col-md-9 col-xs-12">
				<input type="submit" value="Submit" class="btn btn-success btn-block" />
			</div>
		</div>
	</form>
	<?php
}
?>
    </div>
<?php
include dirname(__FILE__).'/admin_footer.php';?>